% Filter specification
wp = 0.4*pi;
ws = 0.6*pi;
dp = 0.01;
ds = 0.001;

% Kaiser window design
d = min([dp ds]);
wc = 0.5*(wp + ws);
dw = abs(wp - ws);
A = -20*log10(d);
[beta,M] = kaiser_estimate(A,dw);
%M = M + 1; % modify window length (filter type)
w = kaiser(M+1,beta); % Kaiser window
h = my_sinc(wc,M); % Rect window
hk = h.*w; % Kaiser winowed filter

NFFT = 2^16;
w = [0:NFFT-1]/NFFT * (2*pi);
H = abs(fft(h,NFFT));
Hk = abs(fft(hk,NFFT));

figure(1);
plot(w/pi,20*log10([H Hk]));
grid on;

